﻿/*
Version: 1.0, requires Writemonkey 2.5.0.8 or higher

Release date: August 25th 2013

Author: Josip

Description: 
Find text quickly and navigate hits.

Installation:
Unzip the "Quick search" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. 
Show search box with CTRL+E,S
Find: start writing
Next down: Down arrow, Enter
Next up: Up arrow
First: Home
Last: End
Clear search field: Delete
Exit: Escape
Back to original location: Insert
*/

// Some settings
var shortcutKey = "S";// Use CTRL+E,S
monkey.setReplacement("/s", "{^es}");
var rememberLastSearch = false; 


// Hit positions bar
var showHitPositions = true;
var hitPositionsWidth = 10;
var hitPositionsHeight = 200;
var hitPositionsOffset = 0; 
var hitPositionsLimit = 200; // don't show hits if more than this value






var panel1 = new System.Windows.Forms.Panel();
var textBox1 = new System.Windows.Forms.TextBox();
var label1 = new System.Windows.Forms.Label();

var optNone = System.Windows.Forms.RichTextBoxFinds.None;
var optReverse = System.Windows.Forms.RichTextBoxFinds.Reverse;

var returnKey = System.Windows.Forms.Keys.Return;
var controlKey = System.Windows.Forms.Keys.Control;
var escapeKey = System.Windows.Forms.Keys.Escape;
var downKey = System.Windows.Forms.Keys.Down;
var upKey = System.Windows.Forms.Keys.Up;
var deleteKey = System.Windows.Forms.Keys.Delete;
var homeKey = System.Windows.Forms.Keys.Home;
var endKey = System.Windows.Forms.Keys.End;
var insertKey = System.Windows.Forms.Keys.Insert;

var colorRed = System.Drawing.Color.DarkRed;
var originalCaretLocation = 0;
var itemSelected = 0;

var pen = new System.Drawing.Pen(monkey.dimmedColor, 1);
var pen2 = new System.Drawing.Pen(colorRed, 2);
var pen3 = new System.Drawing.Pen(monkey.inkColor, 1);
// 
// textBox1
// 
textBox1.BorderStyle = System.Windows.Forms.BorderStyle.None;
textBox1.Size = new System.Drawing.Size(15, 25);
textBox1.Font = new System.Drawing.Font("Courier New", 10, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
textBox1.Location = new System.Drawing.Point(0, 0);
textBox1.Multiline = true;
textBox1.AcceptsReturn = false;
textBox1.Name = "textBox1";
textBox1.Margin = new System.Windows.Forms.Padding(0);
textBox1.TabIndex = 0;
textBox1.BackColor = monkey.dimmedColor;
textBox1.ForeColor = monkey.paperColor;
textBox1.Visible = false;

// 
// label1
// 
label1.AutoSize = true;
label1.Font = new System.Drawing.Font("Courier New", 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
label1.Location = new System.Drawing.Point(15, 0);
label1.Name = "label1";
label1.Size = new System.Drawing.Size(49, 25);
label1.TabIndex = 2;
label1.Text = "";
label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
label1.Visible = false;

//
// panel1
//
panel1.Visible = false;
panel1.BackColor = monkey.paperColor;
panel1.SetBounds(0, textBox1.Height + hitPositionsOffset, hitPositionsWidth, hitPositionsHeight);
var g = panel1.CreateGraphics();

monkey.form.Controls.Add(textBox1);
monkey.form.Controls.Add(label1);
monkey.form.Controls.Add(panel1);

// DEPLOY
// Listen for extended shortcut to execute quick search field
monkey.add_extendedShortcutFiredE(function(object, eventargs) {
	if (eventargs.extendedKey == shortcutKey) {
		originalCaretLocation = monkey.selectionStart;
		// Show quick search field
		label1.BackColor = System.Drawing.Color.Transparent;
		label1.ForeColor = monkey.dimmedColor;
		textBox1.BackColor = monkey.dimmedColor;
		textBox1.ForeColor = monkey.paperColor;
		textBox1.Text = (rememberLastSearch) ? textBox1.Text : "";
		textBox1.Select(textBox1.Text.Length, 0);
		textBox1.Visible = true;
		textBox1.BringToFront();
		textBox1.Focus();
	}
});

// Disable some default keyboard actions
textBox1.add_KeyDown(function(object, eventargs) {
	if (eventargs.KeyData == returnKey || eventargs.KeyData == escapeKey || eventargs.KeyData == controlKey || eventargs.KeyData == insertKey) {
		eventargs.Handled = true;
		eventargs.SuppressKeyPress = true;
	}
});


textBox1.add_TextChanged(function(object, eventargs) {
	if (textBox1.Text.Length == 0 || textBox1.BackColor == colorRed) {
		monkey.select(monkey.selectionStart, 0);
		itemSelected = 0;
		label1.Visible = false;
		panel1.Visible = false;
	}
	else {
		label1.Visible = true;
	}
	textBox1.SetBounds(0,0, 15 + (textBox1.Text.length * 8), textBox1.Height);
	showCount();
});


textBox1.add_Leave(function(object, eventargs) {
	textBox1.Visible = false;
	label1.Visible = false;
	panel1.Visible = false;
});



textBox1.add_KeyUp(function(object, eventargs) {
	
	if (eventargs.KeyData == escapeKey) {
		textBox1.Visible = false;
		label1.Visible = false;
		panel1.Visible = false;
	}
	else if (eventargs.KeyData == downKey || eventargs.KeyData == returnKey) {
	 	isReverse = false;
		 if (findNext(textBox1.Text) == -1) {
			 findFirst(textBox1.Text);
		}
	}
	else if (eventargs.KeyData == upKey) {
		isReverse = true;
		if (findNext(textBox1.Text) == -1) {
			findLast(textBox1.Text);
		}
	}
	else if (eventargs.KeyData == deleteKey) {
		textBox1.Clear();
		textBox1.BackColor = monkey.dimmedColor;
	}
	else if (eventargs.KeyData == homeKey) {
		findFirst(textBox1.Text);
	}
	else if (eventargs.KeyData == endKey) {
		findLast(textBox1.Text);
		}
	else if (eventargs.KeyData == insertKey) {
		monkey.moveCaret(originalCaretLocation);
		monkey.scrollToCaret();
		textBox1.Visible = false;
		label1.Visible = false;
		panel1.Visible = false;		
	}
	else  {
		if (findFirst(textBox1.Text) == -1) {
				label1.Visible = false;
				if (textBox1.Text.length >= 1){
					textBox1.BackColor = colorRed;
				}
		}
		else {
			textBox1.BackColor = monkey.dimmedColor;
			label1.Visible = true;
		}
	}
	showCount();
	drawPositions();

});



function findFirst(text) {
	result = monkey.richTextBox.Find(text, 0, monkey.text.length, optNone);
	monkey.form.PositionScrollMarker();
	itemSelected = 1;
	return result;
}
	
function findLast(text) {
	result = monkey.richTextBox.Find(text, 0, monkey.text.length, optReverse);
	monkey.form.PositionScrollMarker();
	itemSelected = getNumOfHits(textBox1.Text);
	return result;
}

function findNext(text) {
	//isReverse = true;
	if(isReverse) {
		result = monkey.richTextBox.Find(text, 0, monkey.selectionStart - 1, optReverse);
		itemSelected = (itemSelected-- <= 1) ? getNumOfHits(textBox1.Text) : itemSelected--;
		
	}
	else {
		result = monkey.richTextBox.Find(text, monkey.selectionStart + 1, monkey.text.length, optNone);
		itemSelected++;
	}
	monkey.form.PositionScrollMarker();
	return result;
}


function getNumOfHits(text) { 
	//return System.Text.RegularExpressions.Regex.Matches
		//(text, textBox1.Text, System.Text.RegularExpressions.RegexOptions.IgnoreCase).Count;

	if (text.length <= 0)
		return 0;
	else
		return (monkey.richTextBox.Text.Length - monkey.richTextBox.Text.ToLower().Replace(text.toLowerCase(), "").Length) / text.length;
}
   
function showCount () {
	var countString = itemSelected + "/" + getNumOfHits(textBox1.Text);
	label1.SetBounds(textBox1.Width, label1.Location.Y, label1.Width, label1.Height);
	label1.Text = countString;
}

function drawPositions() {
	if (textBox1.TextLength == 0 || showHitPositions == false) 
		return;
	
	panel1.Refresh();
	panel1.SetBounds(0, textBox1.Height + hitPositionsOffset, hitPositionsWidth, hitPositionsHeight);

	// number of lines
	var totalLines = monkey.richTextBox.GetLineFromCharIndex(monkey.text.Length);
	panel1.BringToFront();
	var current = -1;

	var matches = getMatches();
	if (textBox1.Visible == true && textBox1.TextLength >= 2 && matches.Count < hitPositionsLimit && textBox1.BackColor != colorRed) {
		
		panel1.Visible = true;
		pen = new System.Drawing.Pen(monkey.dimmedColor, 1);
		panel1.BackColor = monkey.paperColor;
		
		for (var match in matches) {

			var matchLine = monkey.richTextBox.GetLineFromCharIndex(match.Index);
			var prct = matchLine / totalLines * 100;
			//var hitLocation = prct;
			var hitLocation = (panel1.Height / 100) * prct;
			if (match.Index == monkey.selectionStart) current = hitLocation;
			
			drawPosition(hitLocation);
		}

		if (current > -1) drawCurrent(current);
	}
	else {
		panel1.Visible = false;
	}
}


function drawPosition(y) {
	if (y <= 0) y = 1;
	if (y >= hitPositionsHeight - 1) y = y - 3;
	g.DrawLine(pen, 0, y, hitPositionsWidth, y);
}


function drawCurrent(y) {
	if (y <= 0) y = 1;
	if (y >= hitPositionsHeight) y = y - 3;
	g.DrawLine(pen2, 0, y, hitPositionsWidth, y);
	
	// draw end
	pen3 = new System.Drawing.Pen(monkey.inkColor, 3);
	g.DrawLine(pen3, 0, hitPositionsHeight - 1, hitPositionsWidth, hitPositionsHeight - 1);
}



function getMatches () {
	var m = System.Text.RegularExpressions.Regex.Matches
		(monkey.text, textBox1.Text, System.Text.RegularExpressions.RegexOptions.IgnoreCase);
	return m;
}


/// END ///